<?php
class BusinessCentralAPI
{
    private $TenanID;
    private $ClientId;
    private $ClientSecret;
    private $Scope;
    private $Token = null;
    private $ExpireToken = 0;

    public function __construct()
    {
        $this->TenanID = "05f07637-1572-4dc2-94b2-d5a76d2bd184";
        $this->ClientId = "72a20bad-7783-4b52-af11-73023f8f49d2";
        $this->ClientSecret = "zl98Q~VC6iEKrvs3L5eUjtW8Gq~ZcxIJ4Dud3cxz";
        $this->Scope = "https://api.businesscentral.dynamics.com/.default";
    }

    //Método para pedir token
    private function SolicitarToken()
    {
        $url_token = "https://login.microsoftonline.com/{$this->TenanID}/oauth2/v2.0/token";
        $data = [
            "grant_type" => "client_credentials",
            "client_id" => $this->ClientId,
            "client_secret" => $this->ClientSecret,
            "scope" => $this->Scope
        ];

        $ch = curl_init($url_token);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);

        $response = curl_exec($ch);

        if (curl_error($ch)) {
            echo "CURL Error: " . curl_error($ch);
            exit;
        }

        curl_close($ch);

        $result = json_decode($response, true);

        if (!isset($result['access_token'])) {
            throw new Exception("Error al obtener el token: " . print_r($result, true));
        }

        $this->Token = $result['access_token'];
        $this->ExpireToken = time() + ($result['expires_in'] ?? 3600);
    }

    public function getToken()
    {
        if ($this->Token === null || time() >= $this->ExpireToken) {
            $this->SolicitarToken();
        }
        return $this->Token;
    }

    public function GetOperation($url)
    {
        $token = $this->getToken();
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $token",
            "Accept: application/json"
        ]);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch); //Respuesta

        if (curl_errno($ch)) {
            throw new Exception("CURL GET Error: " . curl_error($ch));
        }

        curl_close($ch);
        return json_decode($response, true);
    }

    public function PostOperation($url, $data)
    {
        $token = $this->getToken();
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $token",
            "Content-Type: application/json",
            "Accept: application/json"
        ]);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("CURL POST Error: " . curl_error($ch));
        }

        curl_close($ch);

        return json_decode($response, true);
    }
}
